<%@ Page Language="VB" AutoEventWireup="false" CodeFile="Create-pdf.aspx.vb" Inherits="Select_MySQL" %>
<%@ Import Namespace="System.Data" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>Create pdf file</title>
</head>
<body>
<form id="form1" runat="server">
     
<h1>Create pdf file from repeater</h1>
This example shows how we can print a pdf document from this repeater control when
the user clicks the button "Print report". The pdf report is generated with itextsharp and we therefore must
ha the file "itextsharp.dll" in the "bin" folder.<br />
    <br />
    Enter enddate:<asp:TextBox ID="txtEndDate" CssClass="textbox" runat="server"></asp:TextBox>
    <asp:Button ID="BtnSelectAssets" CausesValidation="true" ValidationGroup="PrintReport" CssClass="button" runat="server" Text="Create report" /><br />
    <asp:RequiredFieldValidator ID="EndDateRequired" runat="server" ControlToValidate="txtEndDate"
    Display="Dynamic" ErrorMessage="* Enddate must be entered" Width="216px" ValidationGroup="PrintReport">* Enddate must be entered</asp:RequiredFieldValidator>
    <asp:CompareValidator ID="DateCheck" runat="server" ControlToValidate="txtEndDate"
    Display="Dynamic" ErrorMessage="* Date must be entered as yyyy-mm-dd" Operator="DataTypeCheck" Type="Date" ValueToCompare="yyyy-MM-dd" EnableTheming="True" ValidationGroup="PrintReport" SetFocusOnError="True"></asp:CompareValidator>
    <br />
    
    <!-- start parent repeater -->
    <asp:repeater id="parentRepeater" runat="server">
    <HeaderTemplate>
    <table border="0" width="1024px" cellpadding="0" cellspacing="0" style="border: solid 1px silver">
                <tr class="menu" style="height:20px">
                <th>AssetID</th>
                <th>Name</th>
                <th>Purch. date</th>
                <th style="text-align:right">Cost</th>
                <th style="text-align:right">OB acc. depr.</th>
                <th style="text-align:right">Year deprication</th>
                <th style="text-align:right">Acc. depr.</th>
                <th style="text-align:right">Book value</th>
                </tr>
    </HeaderTemplate>
        <itemtemplate>
        <tr id="AccountRow" runat="server" visible='<%#NOT(DataBinder.Eval(Container.DataItem, "PPTotalt") IS DBNull.Value)%>'>
        <td colspan="8" style="font-weight:bold"><asp:Label ID="AssetAccountLiteral" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "AssetAccount")%>'></asp:Label>&nbsp;
        <asp:Label ID="AssetTypeNameLiteral" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "TypeName")%>'></asp:Label></td>
        </tr>
      <!-- start child repeater -->
      <asp:repeater id="childRepeater" datasource='<%# Container.DataItem.Row.GetChildRows("assetsrelation")%>' runat="server">
            <itemtemplate>
                <tr>
                    <td><asp:Literal ID="AssetOwnIDLiteral" runat="server" Text='<%#Container.DataItem("AssetOwnID")%>'></asp:Literal></td>
                    <td><asp:Literal ID="AssetNameLiteral" runat="server" Text='<%#Container.DataItem("AssetName")%>'></asp:Literal></td>
                    <td><asp:Literal ID="PurchaseDateLiteral" runat="server" Text='<%#Format(Container.DataItem("PurchaseDate"), "yyyy-MM-dd")%>'></asp:Literal></td>
                    <td style="text-align:right"><asp:Literal ID="PurchasePriceLiteral" runat="server" Text='<%#Format(Container.DataItem("PurchasePrice"), "# ### ### ##0.00")%>'></asp:Literal></td>
                    <td style="text-align:right"><asp:Literal ID="YearIBLiteral" runat="server" Text='<%#Format(Container.DataItem("YearIB"), "# ### ### ##0.00")%>'></asp:Literal></td>
                    <td style="text-align:right"><asp:Literal ID="YearDepLiteral" runat="server" Text='<%#Format(Container.DataItem("YearDep"), "# ### ### ##0.00")%>'></asp:Literal></td>
                    <td style="text-align:right"><asp:Literal ID="SumAckDepricationLiteral" runat="server" Text='<%#Format(Container.DataItem("SumAckDeprication"), "# ### ### ##0.00")%>'></asp:Literal></td>
                    <td style="text-align:right"><asp:Literal ID="AccountedValueLiteral" runat="server" Text='<%#Format(Container.DataItem("AccountedValue"), "# ### ### ##0.00")%>'></asp:Literal></td>
                </tr>
            </itemtemplate>
      </asp:repeater>
      <!-- end child repeater -->
                <tr id="RowToHide" runat="server" visible='<%#NOT(DataBinder.Eval(Container.DataItem, "PPTotalt") IS DBNull.Value)%>'>
                    <td style="font-weight:bold">Sum:</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td style="text-align:right; font-weight:bold"><asp:Literal ID="PPpriceLabel" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "PPTotalt", "{0:# ### ### ##0.00}")%>'></asp:Literal></td>
                    <td style="text-align:right; font-weight:bold"><asp:Literal ID="IBTotalLabel" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "IBtotalt", "{0:# ### ### ##0.00}")%>'></asp:Literal></td>
                    <td style="text-align:right; font-weight:bold"><asp:Literal ID="YearDepLabel" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "YearDepTotalt", "{0:# ### ### ##0.00}")%>'></asp:Literal></td>
                    <td style="text-align:right; font-weight:bold"><asp:Literal ID="AckDepLabel" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "AckDepTotalt", "{0:# ### ### ##0.00}")%>'></asp:Literal></td>
                    <td style="text-align:right; font-weight:bold"><asp:Literal ID="AccTotalLabel" runat="server" Text='<%#DataBinder.Eval(Container.DataItem, "AccValueTotalt", "{0:# ### ### ##0.00}")%>'></asp:Literal></td>
                </tr>
                <tr id="EmptyRow" runat="server" visible='<%#NOT(DataBinder.Eval(Container.DataItem, "PPTotalt") IS DBNull.Value)%>'>
                <td colspan="8">&nbsp;</td>
                </tr>
   </itemtemplate>                  
   <FooterTemplate>   
        </table>
   </FooterTemplate>
</asp:repeater>
<!-- end parent repeater -->
<br />
<asp:Button ID="btnPrintKvarAnlagg" CssClass="button" runat="server" Text="Print report" Visible="false" /><br />
<br />
    <asp:HiddenField ID="HiddenCompanyID" runat="server" />
    <asp:HiddenField ID="HiddenYearID" runat="server" />
    <asp:HiddenField ID="HiddenCompanyName" runat="server" />
</form>
</body>
</html>

